/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.impl.FcsErrorIds;
import com.ibm.hwmca.fw.fcs.impl.FcsInternalConstants;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Map;

public class ServiceThread
extends Thread
implements FcsInternalConstants {
    private static final String TRACE_MASKD = "XFCSSTHD";
    private static final String TRACE_MASKT = "XFCSSTHT";
    private static final String TRACE_MASKF = "XFCSSTHF";
    private Connection connection;
    private Map map;

    public ServiceThread(Connection connection, Map map) {
        this.connection = connection;
        this.map = map;
    }

    public void run() {
        this.setName("FCS - ServiceThread: Unassociated");
        try {
            if (this.connection != null) {
                FcsConnection fcsConnection = FcsConnection.associate(this.map, this.connection);
                Trace.trace(TRACE_MASKD, "Passing new thread to service: " + (FcsServiceId)this.map.get("serviceId"));
                this.setName("FCS - ServiceThread: " + fcsConnection.getConnectionId());
                FcsServiceId serviceId = (FcsServiceId)this.map.get("serviceId");
                if (FcsServer.getFcsServer().isBlackListed(fcsConnection.getMachineId())) {
                    Trace.trace(TRACE_MASKF, "FCS received a connection from a blacklisted machine.  Closing the socket. " + fcsConnection.getMachineId());
                    this.connection.close();
                } else {
                    FcsService service;
                    if (!FcsServer.getFcsServer().getMachineList().contains(fcsConnection.getMachineId()) && !serviceId.getServiceName().equals("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken")) {
                        DiscoveryCenter.getDiscoveryCenter().foundAddresses(fcsConnection.getMachineId().getNicAddresses(), DiscoveryCenter.fcsInternallyDiscovered);
                    }
                    if ((service = FcsServer.getFcsServer().getService(serviceId)) != null) {
                        Trace.trace(TRACE_MASKD, "service wasn't null, processing connection");
                        this.setName("FCS - ServiceThread (" + fcsConnection.getConnectionId() + ") for service: " + serviceId.getServiceName() + ", " + serviceId.getVersion());
                        UserContext uc = UserContext.getCurrentUserContext();
                        UserContext ucnew = new UserContext(null, uc.getAddress(), 3, uc.getID(), uc.getLocale());
                        ucnew.attachToThread();
                        service.processConnection(fcsConnection);
                    } else {
                        Trace.trace(TRACE_MASKD, "service was null, closing connection");
                        this.connection.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            new FrameworkLog(FcsErrorIds._logInfo, 2146, t).log(FrameworkLogAttributes.INFO_LOG);
        }
    }
}

